import os
from pystyle import Colors, Colorate, Center
import socket
import random
import time

os.system('mode con: cols=120 lines=30')

def intro():
    for i in range(5):
        clear()
        time.sleep(0.1)
        intro_banner()
        time.sleep(0.1)

def intro_banner():
    print(Colorate.Vertical(Colors.red_to_blue, Center.Center(r"""
________        ______                  ________                  _____            
___  __ \____  ____  /____________      __  ___/______________   ____(_)__________ 
__  /_/ /_  / / /_  / _  _ \_  __ \     _____ \_  _ \_  ___/_ | / /_  /_  ___/  _ \
_  ____/_  /_/ /_  /__/  __/  / / /     ____/ //  __/  /   __ |/ /_  / / /__ /  __/
/_/     _\__, / /____/\___//_/ /_/      /____/ \___//_/    _____/ /_/  \___/ \___/ 
        /____/
                                                               



                                                               
    """)))

def set_random_title():
    titles = [
        "PyZen ┃ URL to IP ┃ Python Tool",
        "PyZen ┃ URL to IP ┃ Free Tool",
        "PyZen ┃ URL to IP ┃ .gg/m6FUx2sXXc",
    ]
    title = random.choice(titles)
    if os.name == 'nt':
        os.system(f'title {title}')
    else:
        print(f'\033]0;{title}\a', end='', flush=True)

def get_ip_of_url(url):
    try:
        if url.startswith("http://"):
            hostname = url[len("http://"):]
        elif url.startswith("https://"):
            hostname = url[len("https://"):]
        else:
            hostname = url
        hostname = hostname.split('/')[0]
        ip_address = socket.gethostbyname(hostname)
        if not ip_address:
            raise ValueError("Could not retrieve IP address")
        return ip_address
    except Exception:
        return None
        

def clear():
    os.system("cls" if os.name == "nt" else "clear")

def banner():
    print(Colorate.Vertical(Colors.red_to_blue, Center.XCenter(r"""

________        ______                  ________                  _____            
___  __ \____  ____  /____________      __  ___/______________   ____(_)__________ 
__  /_/ /_  / / /_  / _  _ \_  __ \     _____ \_  _ \_  ___/_ | / /_  /_  ___/  _ \
_  ____/_  /_/ /_  /__/  __/  / / /     ____/ //  __/  /   __ |/ /_  / / /__ /  __/
/_/     _\__, / /____/\___//_/ /_/      /____/ \___//_/    _____/ /_/  \___/ \___/ 
        /____/
    """)))
    print(Colorate.Horizontal(Colors.reset, Center.XCenter("")))

def txt(text):
    print(Colorate.Horizontal(Colors.red_to_blue, Center.XCenter(text)))

def main():
    clear()
    banner()
    set_random_title()
    print(Colorate.Horizontal(Colors.red_to_blue, "╔═════<Enter a URL to get its IP address>"))
    url = input(Colorate.Horizontal(Colors.red_to_blue, "╚═>>> "))
    
    if not url.startswith("http://") and not url.startswith("https://"):
        if not "https://" in url:
            url = "https://" + url
            ip_address = get_ip_of_url(url)
        
    if ip_address:
        set_random_title()
        clear()
        banner()
        print(Colors.green, Center.XCenter(f"{url}"))
        txt("↓ IP Address ↓")
        print(Colors.green, Center.XCenter(ip_address))
        txt("Press Enter to exit")
        input()
    else:
        set_random_title()
        clear()
        banner()
        print(Colors.red, Center.XCenter("Failed to retrieve IP address"))
        input(Colorate.Horizontal(Colors.red_to_blue, Center.XCenter("Enter to Exit")))

intro()
main()